unit Main;

interface


uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OggVorbis, Flac, VorbisComments, StdCtrls, ExtCtrls, ShellApi;
type
  TForm1 = class(TForm)
    BtnLoadFile: TButton;
    OpenDialog1: TOpenDialog;
    EditFilename: TLabeledEdit;
    BtnSave: TButton;
    GroupBox1: TGroupBox;
    EditTitel: TLabeledEdit;
    EditArtist: TLabeledEdit;
    cbAndroidLoop: TCheckBox;
    procedure BtnLoadFileClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtnSaveClick(Sender: TObject);
  private
    { Private-Deklarationen }
    OggVorbisFile: TOggVorbisFile;

    function ValidAudioFile(aFilename: String): Boolean;
    procedure ReadAndShowInfos(aFilename: String);

    procedure WMDropFiles (Var aMsg: tMessage);  message WM_DROPFILES;

  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
    OggVorbisFile := TOggVorbisFile.Create;
    DragAcceptFiles(Handle, True);
    if ParamCount >= 1 then
    begin
        EditFilename.Text := ParamStr(1);
        ReadAndShowInfos(ParamStr(1));
    end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    OggVorbisFile.Free;
end;

procedure TForm1.ReadAndShowInfos(aFilename: String);
var err: TOggVorbisError;
begin
    if ValidAudioFile(aFileName) then
    begin
        EditFilename.Text := aFilename;
        err := OggVorbisFile.ReadFromFile(aFileName);
        if err <> OVErr_None then
        begin
            ShowMessage('Error while reading the file: ' + OggVorbisErrorString[err]);
            exit;
        end;
        // Fill Info-Edits
        EditArtist.Text := OggVorbisFile.Artist      ;
        EditTitel.Text  := OggVorbisFile.Title       ;
        cbAndroidLoop.Checked := AnsiLowercase(OggVorbisFile.GetPropertyByFieldname('ANDROID_LOOP')) = 'true';
    end else
    begin
        ShowMessage('Only *.ogg-files allowed.');
        EditFilename.Text := '';
        EditArtist.Text := '';
        EditTitel.Text  := '';
        cbAndroidLoop.Checked := False;
    end;
end;


function TForm1.ValidAudioFile(aFilename: String): Boolean;
begin
    result := AnsiLowercase(ExtractFileExt(aFilename)) = '.ogg'
end;

procedure TForm1.WMDropFiles(var aMsg: tMessage);
var FileCount, Size: Integer;
    FileName: PChar;
begin
    FileCount := DragQueryFile(aMsg.WParam, $FFFFFFFF, nil, 255);

    if FileCount = 0 then
    begin
        DragFinish (aMsg.WParam);
        exit;
    end;

    if FileCount > 1 then
        ShowMessage('Please drop just one file here. Only the first one will be processed.');

    Size := DragQueryFile (aMsg.WParam, 0, nil, 0) + 2;
    Filename := StrAlloc (Size);

    If DragQueryFile (aMsg.WParam, 0, Filename, Size) = 2 Then
    { nothing } ;
    if (FileGetAttr(UnicodeString(Filename)) AND faDirectory = faDirectory) then
        ShowMessage('Please just drop a file here, no directories.')
    else
        ReadAndShowInfos(UnicodeString(Filename));

    StrDispose(Filename);
    DragFinish (aMsg.WParam);
end;

procedure TForm1.BtnLoadFileClick(Sender: TObject);
begin
    if OpenDialog1.Execute then
    begin
        EditFilename.Text := OpenDialog1.FileName;
        ReadAndShowInfos(OpenDialog1.FileName);
    end;
end;

procedure TForm1.BtnSaveClick(Sender: TObject);
var err: TOggVorbisError;
begin
    if FileExists(EditFilename.Text) then
    begin
        if ValidAudioFile(EditFilename.Text) then
        begin
            OggVorbisFile.Artist      := EditArtist.Text;
            OggVorbisFile.Title       := EditTitel.Text ;
            if cbAndroidLoop.Checked then
                OggVorbisFile.SetPropertyByFieldname('ANDROID_LOOP', 'TRUE')
            else
                OggVorbisFile.SetPropertyByFieldname('ANDROID_LOOP', '');
            OggVorbisFile.UsePadding := True;

            err := OggVorbisFile.WriteToFile(EditFilename.Text);

            if err <> OVErr_None then
            begin
                ShowMessage('An error occured while saving the file: ' + OggVorbisErrorString[err]);
                exit;
            end;
            ReadAndShowInfos(EditFilename.Text);
        end else
            ShowMessage('Only *.ogg-files allowed.');
    end
    else
        ShowMessage('Please open a file first.');
end;



end.



