//
//    Klasse TAudioFile des Tutorials
//    MeMP - Mein Einfacher Mp3-Player
//
//    (c) Dezember 2007, Daniel 'Gausi' Gaumann
//        www.gausi.de, mail@gausi.de
//
//    Du kannst diesen Quellcode ohne Einschrnkung -
//    unverndert oder auch modifiziert in eigenen
//    Projekten verwenden.
//
unit AudioDatei_Klasse;

interface

uses classes, SysUtils, Mp3FileUtils, ATL_WMAFile;

type
    TAudioFile = class
    private
        fInterpret: String;
        fTitel    : String;
        fPfad     : String;
        fDauer    : Integer;

        procedure GetMp3Info;
        procedure GetWmaInfo;
        procedure SetUnknown;

        function GetPlaylistTitel: String;

    public
        property Interpret: String read fInterpret write fInterpret;
        property Titel    : String read fTitel     write fTitel;
        property Pfad     : String read fPfad;
        property Dauer    : Integer read fDauer write fDauer;
        property PlaylistTitel: String read GetPlaylistTitel;

        constructor Create;
        destructor Destroy; override;

        procedure GetAudioInfo(filename: String);
        procedure Assign(aAudioFile: TAudioFile);
    end;


implementation


constructor TAudioFile.create;
begin
  inherited create;
  // hier knnte man einige Dinge initialisieren
end;


destructor TAudioFile.Destroy;
begin
  // hier msste man einiges freigeben, wenn man die Klasse
  // erweitert
  inherited destroy;
end;

// ================================================
// Objekt kopieren
// ================================================
procedure TAudioFile.Assign(aAudioFile: TAudioFile);
begin
  fInterpret := aAudioFile.fInterpret;
  fTitel     := aAudioFile.fTitel    ;
  fPfad      := aAudioFile.fPfad     ;
  fDauer     := aAudioFile.fDauer    ;
end;

// ================================================
// "Interpret - Titel" ausgeben
// ================================================
function TAudioFile.GetPlaylistTitel: String;
begin
  if Trim(fInterpret) = '' then
    result := fTitel
  else
    result := fInterpret + ' - ' + fTitel;
end;


procedure TAudioFile.SetUnknown;
begin
  fTitel := ExtractFileName(fPfad);
  fInterpret := '';
  fDauer := 0;
end;

// ================================================
// Audiodaten ermitteln, Hauptprozedur
// ================================================
procedure TAudioFile.GetAudioInfo(filename: String);
begin
  fPfad := filename;
  try
    if (AnsiLowerCase(ExtractFileExt(filename)) = '.mp3')
      or (AnsiLowerCase(ExtractFileExt(filename)) = '.mp2')
      or (AnsiLowerCase(ExtractFileExt(filename)) = '.mp1')
    then
      GetMp3Info
    else
      if AnsiLowerCase(ExtractFileExt(filename)) = '.wma' then
        GetWMAInfo
      else
        SetUnknown;
  except
    SetUnknown;
  end;
end;

// ================================================
// Audiodaten ermitteln, MP3s
// ================================================
procedure TAudioFile.GetMp3Info;
var mpegInfo: TMpegInfo;
    ID3v2Tag: TID3V2Tag;
    ID3v1tag: TID3v1Tag;
    Stream: TFileStream;
begin
  if NOT FileExists(fPfad) then
  begin
    SetUnknown;
    exit;
  end;

  mpeginfo := TMpegInfo.Create;
  ID3v2Tag := TID3V2Tag.Create;
  ID3v1tag := TID3v1Tag.Create;

  Stream := Nil;
  try
    Stream := TFileStream.Create(fPfad, fmOpenRead or fmShareDenyWrite);
    // ID3v1 Tag auslesen
    id3v1tag.ReadFromStream(Stream);
    // ID3v2 Tag auslesen
    Stream.Seek(0, sobeginning);
    id3v2tag.ReadFromStream(Stream);

    if Not id3v2Tag.exists then
      Stream.Seek(0, sobeginning)
    else
      Stream.Seek(id3v2tag.size, soFromBeginning);
    // Mpeg-Info auslesen
    mpeginfo.LoadFromStream(Stream);
  finally
    if Assigned(Stream) then Stream.free;
  end;

  // Mp3File als Mp3File erkannt? Dann Daten des TAudioDatei setzen
  if mpeginfo.FirstHeaderPosition >- 1 then
  begin
    // aus dem ID3 Tag
    if id3v2tag.artist <> '' then
      fInterpret := id3v2tag.artist
    else
      fInterpret := id3v1tag.artist;

    if id3v2tag.title <> '' then
      fTitel := id3v2tag.title
    else
      if id3v1tag.title <> '' then
        fTitel := id3v1tag.title
      else
        fTitel := ExtractFileName(fPfad);

    // aus den MPEG-Infos
    fDauer   := mpeginfo.dauer;
  end
  else
    SetUnknown;

  MpegInfo.Free;
  Id3v2Tag.Free;
  Id3v1Tag.Free;
end;

// ================================================
// Audiodaten ermitteln, WMA
// ================================================
procedure TAudioFile.GetWmaInfo;
var wmaFile: TWMAfile;
begin
  if NOT FileExists(fPfad) then
  begin
    SetUnknown;
    exit;
  end;

  wmaFile := TWMAFile.create;
  if wmaFile.ReadFromFile(fPfad) then
  begin
    if wmaFile.Title <> '' then
      fTitel := wmaFile.Title
    else
      fTitel := ExtractFilename(fPfad);
    fInterpret := wmaFile.Artist;
    fDauer := Round(wmaFile.Duration);
  end else
    SetUnknown;
  wmaFile.Free;
end;

end.
