{

Nebs - Noch ein Ballspiel

Verffentlicht unter einer Creative-Commons-Lizenz
http://creativecommons.org/licenses/by/3.0/deed.de

2008, Daniel Gaumann
mail@gausi.de

}

unit MovingControls;

interface

uses Windows,StdCtrls, ExtCtrls, SysUtils, Classes, Graphics;

type
    TMovingShape = class(TShape)
    public
      //Positionsnderungen pro Zeiteinheit
      DeltaX: Double;
      DeltaY: Double;
      // Position der Mitte des Shapes
      // Left und Top ergeben sich daraus und Hhe/Breite
      ExactLeft: Double;
      ExactTop: Double;
      Points: Integer;
      isBad: Boolean;
      constructor Create(AOwner: TComponent); Override;
      procedure InitShape(maxSpeed:Integer);
      procedure InitLogoShape(aColor: TColor);
  end;

  TPunktAnzeige = class(TLabel)
    public
      yStart:integer;
      speed:integer;
      procedure InitLabel(x,y,wert:integer);
  end;

  const clHellBlau =   $00F2CF90;
        clDunkelBlau = $00E6A300;
        clOrange = $000080F4;

  const BadColors: Array [0..3] of TColor =
      (
      $008ECCF4, // gelb
      $0057B1EE, // etwas Ocker oder so
      $00C572D3,  // irgendwie Purpur
      $0083CD78 // grn
      );

  const AllColors: Array [0..5] of TColor =
      (
      $008ECCF4, // gelb
      $0057B1EE, // etwas Ocker oder so
      $00C572D3,  // irgendwie Purpur
      $0083CD78, // grn
      $00F2CF90,  // hellblau
      $00E6A300   // dunkelblau
      );



implementation

procedure TPunktAnzeige.InitLabel(x,y,wert:integer);
begin
    yStart:=y;
    speed:=1;
    Left:=x;
    Top:=y;
    AutoSize:=True;
    Caption:=inttostr(wert);
    Transparent:=True;
    Font.Size:=14;
    Font.Style:=[fsbold];
    Font.Color:=clNavy;
end;


Constructor TMovingShape.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  width  := 15;
  height := 15;
end;


procedure TMovingShape.InitShape(maxSpeed: Integer);
begin
  if Random(2)=1 then
  begin
      DeltaX := (1 - 2* random);
      if Random(2) = 1 then
        DeltaY := - sqrt(1-sqr(DeltaX))
      else
        DeltaY := sqrt(1-sqr(DeltaX));
  end else
  begin
      DeltaY := (1 - 2* random);
      if Random(2) = 1 then
        DeltaX := - sqrt(1-sqr(DeltaY))
      else
        DeltaX := sqrt(1-sqr(DeltaY));
  end;

  if Random(10) > 5 then
  begin
    Points := -Random(100);
    isBad := True;
    case Random(3) of
          0: begin
            Shape := stSquare;
            Brush.Color := AllColors[Random(High(Allcolors))];
          end;
          1: begin
            Shape := stRoundSquare;
            Brush.Color := AllColors[Random(High(Allcolors))];
          end;
          2: begin
            Shape := stCircle;
            // Hier eine falsche Farbe nehmen!
            Brush.Color := BadColors[Random(High(Badcolors))];
          end;
    end;

  end else
  begin
    Points := Random(100);
    isBad := False;
    Shape := stCircle;
    if Random(2)=1 then
      Brush.Color := clHellblau
    else
      Brush.Color := clDunkelblau;

  end;

  DeltaX := (Random(maxSpeed) + (maxSpeed / 2)) * DeltaX;
  DeltaY := (Random(maxSpeed) + (maxSpeed / 2)) * DeltaY;
end;

procedure TMovingShape.InitLogoShape(aColor: TColor);
begin
  width  := 15;
  height := 15;
  if Random(2)=1 then
  begin
      DeltaX := (1 - 2* random);
      if Random(2) = 1 then
        DeltaY := - sqrt(1-sqr(DeltaX))
      else
        DeltaY := sqrt(1-sqr(DeltaX));
  end else
  begin
      DeltaY := (1 - 2* random);
      if Random(2) = 1 then
        DeltaX := - sqrt(1-sqr(DeltaY))
      else
        DeltaX := sqrt(1-sqr(DeltaY));
  end;
  Shape := stCircle;
  Brush.Color := aColor;
end;

end.
