{

Nebs - Noch ein Ballspiel

Verffentlicht unter einer Creative-Commons-Lizenz
http://creativecommons.org/licenses/by/3.0/deed.de

2008, Daniel Gaumann
mail@gausi.de

}

unit SpielUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,  StdCtrls, Contnrs, MovingControls, Menus, ExtCtrls;

type
  TSpielform = class(TForm)
    Timer1: TTimer;
    MainMenu1: TMainMenu;
    Spiel1: TMenuItem;
    Starten1: TMenuItem;
    LBLLevel: TLabel;
    LBLPunkte: TLabel;
    CenterBevel: TBevel;
    Hilfe1: TMenuItem;
    ber1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure InitGame;
    procedure SpielShapeMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure Starten1Click(Sender: TObject);
    procedure Hilfe1Click(Sender: TObject);
    procedure ber1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    CenterX: Integer;
    CenterY: Integer;
    GesamtPunkte: Integer;
    Speed: Integer;
    Menge: Integer;
    ShapeList: TObjectlist;
    PunkteList: TObjectList;
    LogoShapeList: TObjectList;
  public
    { Public-Deklarationen }

  end;

const START_SPEED = 2;
      START_MENGE = 1;

var
  Spielform: TSpielform;

implementation

{$R *.dfm}


procedure TSpielform.FormCreate(Sender: TObject);
begin
    Width := 1024;
    Height := 720;
    CenterX := ClientWidth Div 2;
    CenterY := ClientHeight Div 2;
    CenterBevel.Top := CenterY - (CenterBevel.Height DIV 2);
    CenterBevel.Left := CenterX - (CenterBevel.Width DIV 2);

    DoubleBuffered := True;

    ShapeList := TObjectlist.create;
    PunkteList := TObjectList.Create;
    LogoShapeList := TObjectList.Create;
end;

procedure TSpielform.FormDestroy(Sender: TObject);
begin
    ShapeList.Free;
    PunkteList.Free;
    LogoShapeList.Free;
end;

procedure TSpielform.FormShow(Sender: TObject);
begin
  InitGame;
end;

procedure TSpielform.InitGame;
var NewShape: TMovingShape;
    i: Integer;
begin
  GesamtPunkte := 1;
  Speed := START_SPEED;
  Menge := START_MENGE;
  LblPunkte.Caption := 'Punkte: 1';
  LBLLevel.Caption := 'Level 1';

  ShapeList.Clear;
  PunkteList.Clear;
  LogoShapeList.clear;
  for  i := 1 to 7 do
  begin
      NewShape := TMovingShape.Create(SpielForm);
      NewShape.Parent := Self;
      NewShape.ExactLeft := CenterX - (NewShape.Width Div 2);
      NewShape.ExactTop := CenterY - (NewShape.Height Div 2);

      NewShape.Left := CenterX - (NewShape.Width Div 2);
      NewShape.Top  := CenterY - (NewShape.Height Div 2);

      if odd(i) then
          NewShape.InitLogoShape(clHellblau)
      else
          NewShape.InitLogoShape(clDunkelblau);
      LogoShapeList.Add(NewShape);
  end;

  Timer1.Enabled := False; 

  // Tag zhlt die Durchlufe und schaltet den Speed/Menge hoch
  Timer1.Tag := 0;
end;

procedure TSpielform.Starten1Click(Sender: TObject);
begin
    InitGame;
    Timer1.Tag := 0;
    Timer1.Enabled := True;
end;

procedure TSpielform.SpielShapeMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var anzeige:TPunktanzeige;
    wert: Integer;
    aShape: TMovingShape;
    distance: Integer;
begin
  aShape := Sender as TMovingShape;
  distance := round(sqrt(sqr(CenterX - aShape.ExactLeft) + sqr(CenterY - aShape.ExactTop)));
  // maximale Distanz ist ca. 625

  if ashape.isBad then
    // negative Punkte
    // je frher man klickt, desto weniger Punkte >:D
    wert := distance - 625
  else
    // positive Punkte
    // je spter man klickt, desto mehr Punkte
    wert := distance;

  wert := wert DIV 10;

  anzeige := TPunktAnzeige.create(SpielForm);
  anzeige.Parent := Self;
  anzeige.InitLabel(
      aShape.Left + 10,
      aShape.Top,
      wert
    );
  PunkteList.Add(anzeige);

  GesamtPunkte := Gesamtpunkte + wert;
  if Gesamtpunkte < 1 then
    Gesamtpunkte := 1;
  LblPunkte.Caption := 'Punkte: ' + IntToStr(Gesamtpunkte);
  ShapeList.Remove(ashape);
end;

procedure TSpielform.Timer1Timer(Sender: TObject);
var aShape, NewShape: TMovingShape;
  i: integer;
  distance:double;
  anzeige: TPunktAnzeige;
  tmpl, tmpt:integer;

begin
  timer1.Enabled := False;
  if Random(100) <= Menge then
  begin
      NewShape := TMovingShape.Create(SpielForm);
      NewShape.Parent := Self;
      NewShape.ExactLeft := CenterX - (NewShape.Width Div 2);
      NewShape.ExactTop := CenterY - (NewShape.Height Div 2);
      NewShape.Left := CenterX - (NewShape.Width Div 2);
      NewShape.Top  := CenterY - (NewShape.Height Div 2);
      NewShape.OnMouseDown := SpielShapeMouseDown;
      NewShape.InitShape(Speed);
      ShapeList.Add(NewShape);
  end;

  for i:= ShapeList.Count - 1 downto 0 do
  begin
    aShape := ShapeList[i] as TMovingShape;
    if (ashape.ExactLeft < -20)
       OR (ashape.ExactLeft > ClientWidth + 20)
       OR (ashape.ExactTop < -20)
       OR (ashape.ExactTop > ClientHeight + 20)
    then
    begin
        if Not aShape.isBad then
        begin
          if LogoShapeList.Count = 0 then
          begin
            MessageBox(self.Handle, PChar('Sie haben '+  IntToStr(GesamtPunkte) + ' Punkte erreicht.'+#13+#10+''+#13+#10+'Herzlichen Glckwnsch!'), 'Game Over', MB_ICONINFORMATION or MB_OK or MB_APPLMODAL	);

            InitGame;
            exit;
          end;
          LogoShapeList.Delete(LogoShapeList.Count - 1);
        end;
        ShapeList.Delete(i);
    end else
    with aShape do
    begin
        ExactLeft := ExactLeft + DeltaX;
        ExactTop := ExactTop + DeltaY;

        if width < 65 then
        begin
          distance := sqrt(sqr(CenterX - ExactLeft) + sqr(CenterY - ExactTop));
          if distance < 110 then
          begin
            width := round(10 + 0.5 * distance);
            height := round(10 + 0.5 * distance);
          end;
        end;

        tmpl := Round(ExactLeft - Width/2);
        tmpt := Round(ExactTop - Height/2);

        if (tmpl<>Left) OR (tmpt<>top) then
        begin
          Left := tmpl;
          Top := tmpt;
        end;
    end;
  end;   // for ShapeList.Count

  for i := PunkteList.Count - 1 downto 0 do
  begin
      anzeige:=PunkteList[i] as TPunktanzeige;
      if anzeige.yStart - anzeige.Top > 15 then
      begin
        anzeige.Caption:='';
        PunkteList.Delete(i);
      end else
        anzeige.Top:=anzeige.Top-anzeige.speed;
  end;

  for I := 0 to LogoShapeList.Count - 1 do
  begin
    aShape := LogoShapeList[i] as TMovingShape;
    with aShape do
    begin
        if abs(CenterX - ExactLeft) > 42 then
          DeltaX := - DeltaX;

        if abs(CenterY - ExactTop) > 42 then
          DeltaY := - DeltaY;

        ExactLeft := ExactLeft + DeltaX;
        ExactTop := ExactTop + DeltaY;

        tmpl := Round(ExactLeft - Width/2);
        tmpt := Round(ExactTop - Height/2);

        if (tmpl<>Left) OR (tmpt<>top) then
        begin
          Left := tmpl;
          Top := tmpt;
        end;
    end;
  end;

  // Schwierigkeit erhhen und "Leben" auch um eins
  Timer1.Tag := Timer1.Tag + 1;
  if Timer1.Tag MOD 300 = 0 then
  begin
      Timer1.Tag := 0;
      if Menge < Speed then
        inc(Menge)
      else
        inc(Speed);
      LBLLevel.Caption := 'Level ' + IntToStr(Speed + Menge - 3);

      // Leben erhhen
      // d.h. in der Mitte eins dazu :D
      NewShape := TMovingShape.Create(SpielForm);
      NewShape.Parent := Self;
      NewShape.ExactLeft := CenterX;
      NewShape.ExactTop := CenterY;
      NewShape.Left := Round(CenterX - NewShape.Width/2);
      NewShape.Top  := Round(CenterY - NewShape.Height/2);

      if NOT odd(LogoShapeList.Count) then
          NewShape.InitLogoShape(clHellblau)
      else
          NewShape.InitLogoShape(clDunkelblau);
      LogoShapeList.Add(NewShape);
  end;    // if Timer mod = 0

  Timer1.Enabled := True;
end;





procedure TSpielform.Hilfe1Click(Sender: TObject);
begin
  MessageDlg('Spielregeln:'+#13+#10+''+#13+#10+'- Blaue Blle durch Anklicken einfangen'+#13+#10+'- Andere Dinge nicht (gibt Minuspunkte)'+#13+#10+'- Bei Levelaufstieg gibt es in der Mitte einen blauen Ball mehr'+#13+#10+'- Bei einem verpassten blauen Ball gibts einen Abzug'+#13+#10+'- Das Spiel endet, wenn kein Ball mehr in der Mitte ist', mtInformation, [mbOK], 0);
end;

procedure TSpielform.ber1Click(Sender: TObject);
begin
  MessageDlg('Nebs - Noch ein Ballspiel'+#13+#10+''+#13+#10+'(c) 2008, Daniel Gauman'+#13+#10+'mail@gausi.de', mtInformation, [mbOK], 0);
end;

end.
