unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ShellApi, IniFiles, StdCtrls, ExtCtrls, ScrobblerUtils;


type
  TForm1 = class(TForm)
    GrpBox_ScrobblerSetup: TGroupBox;
    BtnGetToken: TButton;
    BtnAuthorize: TButton;
    BtnGetSessionKey: TButton;
    Label1: TLabel;
    GrpBox_PseudoPlayer: TGroupBox;
    Label2: TLabel;
    Edt_Interpret: TEdit;
    Label3: TLabel;
    Edt_Titel: TEdit;
    Label4: TLabel;
    Edt_Album: TEdit;
    Edt_Length: TEdit;
    Label5: TLabel;
    Edt_TrackNr: TEdit;
    Label6: TLabel;
    GrpBox_ScrobbleLog: TGroupBox;
    Mem_ScrobbleLog: TMemo;
    BtnPlay: TButton;
    BtnStop: TButton;
    BtnNext: TButton;
    Label7: TLabel;
    ImgLastFM: TImage;
    Label8: TLabel;
    CB_DoScrobble: TCheckBox;
    PlayerShape: TShape;
    LblPlayerStatus: TLabel;
    PlayerTimer: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtnGetTokenClick(Sender: TObject);
    procedure BtnAuthorizeClick(Sender: TObject);
    procedure BtnGetSessionKeyClick(Sender: TObject);
    procedure BtnPlayClick(Sender: TObject);
    procedure BtnStopClick(Sender: TObject);
    procedure BtnNextClick(Sender: TObject);
    procedure ImgLastFMClick(Sender: TObject);
    procedure CB_DoScrobbleClick(Sender: TObject);
    procedure PlayerTimerTimer(Sender: TObject);
  private
    { Private-Deklarationen }
  protected
      Procedure ScrobblerMessage(Var aMsg: TMessage); message WM_Scrobbler;
  public
    { Public-Deklarationen }
    PlayerStatus: Integer;
  end;

var
  Form1: TForm1;
  DemoScrobbler: TApplicationScrobbler;


const
  ps_Stopped = 0;
  ps_Paused = 1;
  ps_Playing = 2;

implementation

{$R *.dfm}


// ApplicationScrobbler erzeugen.
// ACHTUNG! Das hier verwendete ApiKey/Secret-Paar ist NUR ZU DEMOZWECKEN gedacht.
// Wenn diese Demo weiterentwickelt werden soll
//           - AUCH DANN, WENN ES NUR ZU PRIVATEN ZWECKEN IST -
// bitte bei LastFM einen eigenen Key/Secret besorgen.
// Das geht autoamtisiert ber den Link http://www.lastfm.de/api/account
//
// Zum Testen einer Software ist die Client-ID 'tst' mit Version '1.0' gedacht.
// Man DARF NICHT diese ID/Version in der fertigen verffentlichten Software
// verwenden, und man DARF NICHT die ID/Version von anderen Anwendungen benutzen.
// Sie kann ber submissions@last.fm beantragt werden, siehe API-Doku fr Details
// http://www.lastfm.de/api
//
// ber die ID erscheint dann ein "Hrt gerade mit <ganz tolles Programm>"
// im Userprofil des Nutzers.
procedure TForm1.FormCreate(Sender: TObject);
var Ini: TMemIniFile;
begin
    DemoScrobbler := TApplicationScrobbler.Create(Handle);

    {$MESSAGE 'Api-Key und Secret sollten UNBEDINGT geaendert werden. Passende Keys/Secrets werden von LastFM vergeben.'}
    DemoScrobbler.ApiKey := 'f7fa672081fb6bf5a1e9ae618dcd4fdf';
    DemoScrobbler.Secret := 'a8e2b589b4ef051044fabc287f9e09bd';
    {$MESSAGE 'Beantragen Sie bei LastFM eine eigene ClientID, wenn Sie ihre Anwendung veroeffentlichen.'}
    DemoScrobbler.ClientID := 'tst';
    DemoScrobbler.ClientVersion := '1.0';

    Ini := TMemIniFile.Create(ExtractFilePath(ParamStr(0)) + 'Scrobbler.ini');
    try
        DemoScrobbler.LoadFromIni(Ini);
    finally
        Ini.Free;
    end;
    Mem_ScrobbleLog.Lines.Assign(DemoScrobbler.LogList);

    PlayerStatus := ps_Stopped;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    DemoScrobbler.Free;
end;

// Link zu LastFM
procedure TForm1.ImgLastFMClick(Sender: TObject);
begin
    ShellExecute(Handle, 'open', 'http://www.last.fm', nil, nil, SW_SHOW);
end;


// ---------------------------------------------------------
// ---------------------------------------------------------
// Message-Handler fr TApplicationScrobbler
// ---------------------------------------------------------
// ---------------------------------------------------------
// Das Scrobbeln luft in eigenen Threads ab.
// Diese schicken je nach Ergebnis ihrer Arbeit diverse Nachrichten
// an das Fenster unserer Anwendung.
// Auf diese Nachrichten mssen wir entsprechend reagieren
Procedure TForm1.ScrobblerMessage(Var aMsg: TMessage);
var aList: TStrings;
    responseString: AnsiString;
    Ini: TMemIniFile;
begin
    Case aMsg.WParam of
        SC_Message: DemoScrobbler.LogList.Add(PChar(aMsg.LParam));
        SC_BeginWork: GrpBox_ScrobbleLog.Caption := 'Scrobbel-Log (Status: Sende Daten...)';
        SC_EndWork:  GrpBox_ScrobbleLog.Caption := 'Scrobbel-Log (Status: Idle)';
        SC_TooMuchErrors: DemoScrobbler.LogList.Add('Oops. Zu viele Fehler. Neuer Handshake bentigt.');

        // ======================================================
        // Authorisierung, Teil 1: GetToken
        // ======================================================
        SC_GetTokenException: begin
            DemoScrobbler.LogList.Add(PAnsiChar(aMsg.LParam));
            DemoScrobbler.JobDone;
        end;
        SC_GetToken: begin
            responseString := PAnsiChar(aMsg.LParam);
            //Token aus Antwort bestimmen
            DemoScrobbler.Token := GetTokenFromResponse(responseString);
            if DemoScrobbler.Token <> '' then
                DemoScrobbler.LogList.Add('GetToken: OK ... ' + DemoScrobbler.Token)
            else
                DemoScrobbler.LogList.Add('GetToken: FAILED ... ');
            DemoScrobbler.JobDone;
        end;

        // ======================================================
        // Authorisierung, Teil 3: GetSession (Teil 2 findet im Browser statt ;-) )
        // ======================================================
        SC_GetSessionException: begin
            DemoScrobbler.LogList.Add(PAnsiChar(aMsg.LParam));
            DemoScrobbler.JobDone;
        end;
        SC_GetSession: begin
            responseString := PAnsiChar(aMsg.LParam);
            DemoScrobbler.Username := GetUserNameFromResponse(responseString);
            if DemoScrobbler.Username <> '' then
                DemoScrobbler.LogList.Add('GetUserName: OK ... ' + DemoScrobbler.Username)
            else
                DemoScrobbler.LogList.Add('GetUserName: FAILED ... ');

            DemoScrobbler.SessionKey := GetSessionKeyFromResponse(responseString);
            if DemoScrobbler.SessionKey <> '' then
                DemoScrobbler.LogList.Add('GetSessionKey: OK ... ' + DemoScrobbler.SessionKey)
            else
                DemoScrobbler.LogList.Add('GetSessionKey: FAILED ... ');

            // Handshake wieder erlauben, falls es vorher verboten wurde.
            DemoScrobbler.AllowHandShakingAgain;

            // Daten in Ini speichern. Die braucht man spter wieder. ;-)
            Ini := TMemIniFile.Create(ExtractFilePath(ParamStr(0)) + 'Scrobbler.ini');
            try
                DemoScrobbler.SaveToIni(Ini);
            finally
                Ini.UpdateFile;
                Ini.Free;
            end;
            DemoScrobbler.JobDone;
        end;

        // ======================================================
        // HandShake
        // ======================================================
        SC_HandShakeError: Begin
            // Im LParam steckt der Errorcode drin. Banned, Baduth, etc.
            DemoScrobbler.LogList.Add('Handshake fehlgeschlagen: ' + ScrobbleStatusStrings[aMsg.LParam]);
            DemoScrobbler.HandleHandshakeFailure(TScrobbleStatus(aMsg.LParam));
            // Hier ggf. "Laute" Rckmeldung an den User
            MessageDlg(ScrobbleFailureWait, mtWarning, [mbOK], 0);
        end;

        SC_HandShakeCancelled: begin
            // Handshake wurde unterbunden
            // LParam: ca. Zeit bis nchster Handshake erlaubt ist
            DemoScrobbler.LogList.Add('Scrobbling fr ca. ' + IntToStr(aMsg.lParam) + ' Minuten deaktiviert.'  );
            DemoScrobbler.HandleHandshakeFailure(hs_OK); // D.h. Eigentlich alles Ok => einfach nur fWorking auf False setzen.
        end;

        SC_HandShakeException: Begin
            // LParam: ErrorMessage
            DemoScrobbler.LogList.Add(PAnsiChar(aMsg.LParam));
            DemoScrobbler.HandleHandshakeFailure(hs_EXCEPTION);
            // Hier ggf. "Laute" Rckmeldung an den User
            MessageDlg(ScrobbleFailureWait, mtWarning, [mbOK], 0);
        end;

        // Message kommt nur an, wenn result = OK, trotzdem minimal gegenchecken. ;-)
        SC_HandShakeComplete: begin
            // LParam: Liste mit 'OK', ID, 2xURL
            aList := TStringlist.Create;
            try
                aList.CommaText := PAnsiChar(aMsg.LParam);
                if aList.Count >= 4 then
                begin
                    DemoScrobbler.SessionID     := aList[1];
                    DemoScrobbler.NowPlayingURL := aList[2];
                    DemoScrobbler.SubmissionURL := aList[3];
                    DemoScrobbler.LogList.Add('HandShake Complete:');
                    DemoScrobbler.LogList.Add('    SessionID: ' + DemoScrobbler.SessionID);
                    DemoScrobbler.LogList.Add('    NowPlayingURL: ' + DemoScrobbler.NowPlayingURL);
                    DemoScrobbler.LogList.Add('    SubmissionURL: ' + DemoScrobbler.SubmissionURL);
                    DemoScrobbler.CountSuccess;
                end else
                begin
                    DemoScrobbler.LogList.Add('Oops, da ist beim Handshake aber was grndlich schief gegangen...');
                    DemoScrobbler.HandleHandshakeFailure(hs_UnknownFailure);
                end;
            finally
                aList.Free;
            end;
        end;

        // ======================================================
        // NowPlaying-Notification
        // ======================================================
        SC_NowPlayingError: begin
            DemoScrobbler.LogList.Add('Scrobbling ("Now Playing Notification") fehlgeschlagen: ' + ScrobbleStatusStrings[aMsg.LParam]);
            DemoScrobbler.CountError(TScrobbleStatus(aMsg.LParam));
            DemoScrobbler.ScrobbleAgain(PlayerStatus = ps_Playing);
        end;
        SC_NowPlayingException: begin
            // lparam: ErrorMessage
            DemoScrobbler.LogList.Add(PAnsiChar(aMsg.LParam));
            DemoScrobbler.CountError(TScrobbleStatus(aMsg.LParam));
        end;
        SC_NowPlayingComplete: begin
            DemoScrobbler.LogList.Add(UTF8Decode(PAnsiChar(aMsg.LParam)));
            DemoScrobbler.CountSuccess;
            DemoScrobbler.ScrobbleNextCurrentFile(PlayerStatus = ps_Playing);
        end;

        // ======================================================
        // Submission
        // ======================================================
        SC_SubmissionError: begin
            DemoScrobbler.LogList.Add('Scrobbling fehlgeschlagen: ' + ScrobbleStatusStrings[aMsg.LParam]);
            DemoScrobbler.CountError(TScrobbleStatus(aMsg.LParam));
            DemoScrobbler.ScrobbleAgain(PlayerStatus = ps_Playing);
        end;
        SC_SubmissionException: begin
            // lparam: ErrorMessage
            DemoScrobbler.LogList.Add(PAnsiChar(aMsg.LParam));
        end;
        SC_SubmissionComplete: begin
            DemoScrobbler.LogList.Add(UTF8Decode(PAnsiChar(aMsg.LParam)));
            DemoScrobbler.CountSuccess;
            DemoScrobbler.ScrobbleNext(PlayerStatus = ps_Playing);
        end;
        SC_SubmissionSkipped: begin
            DemoScrobbler.LogList.Add(PAnsiChar(aMsg.LParam));
        end;
    end;

    // Auch in Log-Memo schreiben
    Mem_ScrobbleLog.Lines.Assign(DemoScrobbler.LogList);
    Mem_ScrobbleLog.selstart := length(Mem_ScrobbleLog.text);
    Mem_ScrobbleLog.SelLength := 1;
end;


// ---------------------------------------------------------
// ---------------------------------------------------------
// Scrobble-Setup. Muss einmal durchgefhrt werden, danach kann
// man die Werte aus einer Ini/Registry/... laden
// ---------------------------------------------------------
// ---------------------------------------------------------
// Authentifizierung, Schritt 1:
// Token holen
// Dieses ist ca. 1h lang gltig, und muss von einem
// LastFM-User besttigt werden.
procedure TForm1.BtnGetTokenClick(Sender: TObject);
begin
    DemoScrobbler.GetToken;
end;

// Mit dem aus Schritt 1 erhaltenen Token wird
// der Nutzer auf LastFM verwiesen, wo er "Yes, allow access" klicken soll
procedure TForm1.BtnAuthorizeClick(Sender: TObject);
var authUrl: AnsiString;
begin
    authUrl := 'http://www.last.fm/api/auth/?api_key=' + DemoScrobbler.ApiKey + '&token=' + DemoScrobbler.Token;
    ShellExecuteA(Handle, 'open', PAnsiChar(authUrl), nil, nil, SW_SHOW);
end;

// Das Token ist authentifiziert.
// Wir knnen nun einen Sessionkey anfordern.
// In der Antwort vom Server steckt dann auch der LastFM-Username
// drin
procedure TForm1.BtnGetSessionKeyClick(Sender: TObject);
begin
    DemoScrobbler.GetSession;
end;

// Setzt die Laufzeitvariable "DoScrobble" auf True
procedure TForm1.CB_DoScrobbleClick(Sender: TObject);
begin
    DemoScrobbler.DoScrobble := CB_DoScrobble.Checked;
end;


// ---------------------------------------------------------
// ---------------------------------------------------------
// Ein bissel Pseudo-Player-Code
// ---------------------------------------------------------
// ---------------------------------------------------------
// Die DemoScrobbler.Playback*-Aufrufe dienen dem ermitteln der
// Spieldauer des aktuellen Liedes, um daraus zu ermitteln,
// ob am Ende des Liedes gescrobbelt werden soll oder nicht
procedure TForm1.BtnPlayClick(Sender: TObject);
begin
    case PlayerStatus of
        ps_Stopped: begin
            // Player ist gestoppt.
            // gewnschte Aktion: Neues Lied starten
            DemoScrobbler.ChangeCurrentPlayingFile(
                Edt_Interpret.Text,
                Edt_Titel.Text,
                Edt_Album.Text,
                StrToIntDef(Edt_Length.Text, 0),
                StrToIntDef(Edt_TrackNr.Text, 0) );

            DemoScrobbler.PlaybackStarted;
            BtnPlay.Caption := 'Pause';
            PlayerStatus := ps_Playing;
        end;
        ps_Paused: begin
            // Player ist pausiert.
            // Gewnschte Aktion: Weiterspielen
            DemoScrobbler.PlaybackResumed;
            BtnPlay.Caption := 'Play';
            PlayerStatus := ps_Playing;
        end;

        ps_Playing: begin
            // Player spielt.
            // Gewnschte Aktion: Player pausieren
            DemoScrobbler.PlaybackPaused;
            BtnPlay.Caption := 'Pause';
            PlayerStatus := ps_Paused;
        end;
    end;
end;

// Hlt die Wiedergabe an und startet das Scrobbeln
// Der DemoScrobbler entscheidet dabei selbststndig, ob
// das gerade gehrte Lied bertragen werden soll oder nicht
procedure TForm1.BtnStopClick(Sender: TObject);
begin
    // Scrobbeln !
    DemoScrobbler.AddToScrobbleList(PlayerStatus = ps_Playing);

    // Stoppen
    BtnPlay.Caption := 'Play';
    PlayerStatus := ps_Stopped;
end;

// Stoppt die Wiedergabe des Pseudoplayers,
// scrobbelt das zuvor gehrte Lied,
// setzt das aktuelle Lied um,
// und startet die Wiedergabe
procedure TForm1.BtnNextClick(Sender: TObject);
begin
    // aktuelles Lied Scrobbeln, das dadurch gestoppt wird
    DemoScrobbler.AddToScrobbleList(PlayerStatus = ps_Playing);

    BtnPlay.Caption := 'Pause';
    PlayerStatus := ps_Playing;

    DemoScrobbler.ChangeCurrentPlayingFile(
        Edt_Interpret.Text,
        Edt_Titel.Text,
        Edt_Album.Text,
        StrToIntDef(Edt_Length.Text, 0),
        StrToIntDef(Edt_TrackNr.Text, 0) );
    DemoScrobbler.PlaybackStarted;
end;

procedure TForm1.PlayerTimerTimer(Sender: TObject);
begin
    case PlayerStatus of
        ps_Stopped: begin
            LblPlayerStatus.Caption := 'Player gestoppt';
            PlayerShape.Brush.Color := clWhite;
        end;
        ps_Paused: begin
            LblPlayerStatus.Caption := 'Player macht Pause';
            PlayerShape.Brush.Color := clgray;
        end;
        ps_Playing: begin
            LblPlayerStatus.Caption := 'Player macht Musik';
            PlayerShape.Brush.Color := random($ffffff);
        end;
    end;
end;

end.
